<?php

/**
 * This is a client-side library for using the i-mon-it services.
 * This library contains several static functions, which make remote calls to the i-mon-it server.In order to use the i-mon-it micro services
 *  you need to include this library and imonit_client_lib.php into every page and class you want to monitor with the i-mon-it  service.
 *   In order to use the services you need to call the centrali-mon-it Saas  micro services. Below  you find the explanation how to do this:
 *   1. In order to track the start of your page you would need to call the static method imonit_client::startPage() and at the end of your page
 *    you need to call the corresponding static  method: imonit::endPage(). In this documentation you find the required parameters in order
 *     to call these static methods. In order to track and morning tour your business logic you would would use the following static
 *      methods: for starting one of your methods in your business logicimoint_client::start() .
 *       and for ending a message in your business logic use: imoni_client::end()
 *
 * @see imonit_client::start()
 * @see imonit_client::gettokenid ()
 * @see imonit_client::mid()
 * @see imonit_client::end()
 * @see imonit_client::startPage ()
 * @see imonit_client::lastentry()
 * @see imonit_client::midPage()
 * @see imonit_client::endPage()
 * @see imonit_client::__construct()
 * @see imonit_client::verifytoken()
 * @see imonit_client::updatetoken()
 * @see imonit_client::ua()
 * @author Stephan Haux
 * @copyright 2025 i-mon-it
 * @version 00.01.181 29.11.2025
 * @name i-mon-it Client
 * @category library
 *  @api
 *
 */
if (session_status() != PHP_SESSION_ACTIVE) {
    session_start();
} else {}
if (! defined('Credentials_loaded')) {

    require_once 'imonit_client_lib.php';
    /**
     * This is the name of the i-mon-it website.
     *
     * @var string name of the i-mon-it website
     */
    define('local_server', '.i-mon-it.local');
    /**
     * Name of the central tracking server of the i-mon-it services.
     * Do not change this, neither in your development or staging environment and certainly not in the production environment.
     *
     * @var string Name of the center tracking server of the i-mon-it services.
     */
    $islocal = str_contains($_SERVER['HTTP_HOST'], '.local');
    //debug(detailiert,' <p >Debug:'.__FILE__.' (#'.__LINE__.' '.version.') Für die aufrufende Webseite "'. $_SERVER['HTTP_HOST'].'" Wurde sie als lokal ermittelt?'.janein ( $islocal).' </p>'.PHP_EOL);
    if ($islocal) {
        define('imonit_server', 'server.i-mon-it.local');
    } else {
        define('imonit_server', 'server.i-mon-it.de');
    }
    /**
     * This URL used by the central i-mon-it tracking service to fire monitoring and administrative requests.
     * Do not change the value of the constant.
     *
     * @var string URL used the fire monitoring and administrative requests to the i-mon-it service.
     */
    define('listener', 'http://' . imonit_server . '/');
    /**
     * this is the URL used to send the monitoring request for the start.
     *
     * @var String URL start Service
     * @see imonit_client::start ()
     */
    define('start', listener . 'start.php');
    /**
     * This is the microservice for retrieving the last id of a particular call.
     *
     * @var String
     */
    define('lastentry', listener . 'lastentry.php');

    /**
     * This is the URk base for retrieving the Useragent id.
     *
     * @var string
     * @see imonit_client::ua()
     */
    define('ua', listener . 'UA.php');
    /**
     * This is the URL for the startpage service.
     *
     * @var String URL for the startpage service
     * @see imonit_client::startpage ()
     */
    define('startpage', listener . 'startpage.php');
    /**
     * URL for the mid service.
     *
     * @var string Urlfor the mid service
     * @see imonit_client::mid()
     */
    define('mid', listener . 'mid.php');
    /**
     * URL for the end service.
     *
     * @var String URL for the end Service
     * @see imonit_client::end()
     */
    define('end', listener . 'end.php');
    /**
     * URL for the endpage service.
     *
     * @var String URL for the endpage service
     * @see imonit_client::endpage ()
     */
    define('endpage', listener . '/endpage.php');

    /**
     * URL for the midpage service.
     *
     * @var String URL for the endpage service
     * @see imonit_client::endpage ()
     */
    define('midpage', listener . '/midpage.php');
    /**
     * URL for the updatetoken service
     *
     * @var string
     * @see imonitclient::updatetoken()
     */
    Define('updatetoken', listener . '/updatetoken.php');
    /**
     * URL for the verifytoken service
     *
     * @var string URL for the verifytoken service
     * @see imonit_client::verifytoken()
     */
    define('checktoken', listener . '/checktoken.php');

    /**
     * This is the name of the session variable holding information about the token number used on the website to be monitored.
     * you
     */
    define('itoken', 'token');
    /**
     * Name of the local file holding the token information.
     *
     * @var string Name of the tokenfile holding the correct information.
     */
    define('itokenfilename', 'imonit.token');

    /**
     * This is the implementation of the client-side class to use the i-mon-it micro services.
     * In order to use the services you would simply
     * call the required static functions. And in order to provide the state static methods with information about your particular web application you would
     * instantiate the imonit_client class, in order to retrieve that identification information of your web application within the imonit eco system. In order to do so you would use the following lines of code:
     * $client = new imonit_client();
     * $token = $client->gettokenid();
     * $aktion = 'Your action';
     * const version = 'nn.nn.nnn dd.mm.yyyy';
     * $startid = imonit_clients::startpage($token, __file__,__line__,$paid, $aktion,version);
     * Yourcode
     * $midid = imonit_client::midpage($token,$startid, __file__,__line__,$paid, $ktion,version);
     * $endid = imonit_client::endPage($token,$startid, __file__,__line__,$paid, $ktion,version);
     *
     * If you use i-mon-it to optimize your core Webapplication, then you would use the methods 'start', 'mid' and 'end'. The usage of those three
     * methods is pretty much the same as the one for monitoring your pages. The start method creates with the return value startid the reference points
     * for the other two methods would you meant to be used within a method (mid) or at the end of your message typically right before you give back the results of your method.
     * version 00.01.168 17.10.2025 minor Error correction with getting the download of the toke. It was a typo.
     *
     * @name imonit_client
     * @author i-mon-it Stephan Haux
     * @copyright 2026 i-mon-it
     * @version 00.01.182 02.01.2026
     *          version 00.01.169 17.10.2025 some work on Microservice "updatetoken" required.
     */
    class imonit_client
    {

        /**
         * This constant is holding the current version and the date of the last change.
         *
         * @var string version and date of change Format:nn.nn.nnn dd.mm.yyyy
         */
        public const version = '00.01.182 02.01.2026';

        /**
         * This is the name of the local token found in the root directory on the Web server
         *
         * @var string name of the token found for this web application.
         * @see imonit_client::gettokenname ()
         */
        private string $token = '';

        /**
         * This is the indicator holding information whether the token found and loaded is valid or not.
         *
         * @var bool
         * @see imonit_client::isvalid()
         */
        private bool $isvalid = false;

        /**
         * Version of the token which was loaded into the current instance of the class.
         *
         * @var string version Of the token declaration loaded into the instance of the class.
         * @see imonit_client::gettokenversion()
         */
        private string $tokenversion = '';

        /**
         * This string holds the hash value used for identification and verification of the token at the central i-mon-it Service.
         *
         * @var string Hash value for the Token
         * @see imonit_client::verifytoken()
         */
        private string $hash = '';

        /**
         * Holds is a unique identifier of the token within the i-mon-it ecosystem.
         *
         * @var int Tokenid within the i-mon-it ecosystem
         * @see imonit_client::gettokenid()
         */
        private int $tokenid = - 1;

        /**
         * This is representing the customer number token belongs to
         *
         * @var int custom number of the token owner
         * @see imonit_client::getsustomernumber()
         */
        private int $customernumber = - 1;

        /**
         * Name of the website associated with the token
         *
         * @var string website associated with the token.
         */
        private string $websidename = '';

        /**
         * This is the id of the wbsite, which is mnitored by the service.
         * This number refer s the i-mon-it central database. It is set by the token.
         *
         * @var int Number of the website as named in the i-mon-it central service.
         * @se imonit_client::getwebsiteid()
         */
        private int $websiteid = - 1;

        /**
         * Name of the token file loaded into the class.
         *
         * @var string Name of the token file loaded into the class.
         * @see imonit_client::updatetoken ()
         */
        private string $tokenfilename = '';

        /**
         * This is the date: when when the token file requires an update from the i-mon-itserver
         *
         * @var DateTime
         * @see imonit_client::updatetoken()
         */
        private DateTime $nextupdate;

        /**
         * String of the user agent from the browser as it is recorded by the Web server.
         *
         * @var string User agent string as provided by the browser and the Web server.
         */
        private string $useragent = '';

        /**
         * This static method retrieves the last entry within the database regarding the current webappplication.
         *
         * @param string $fileorMethod
         *            Mane of the calling Method or file.
         * @param string $aktion
         *            Name of the action that should be associated with this call.
         * @return int Returns the number of the last entry in the i-mon-it database
         */
        public static function lastentry(string $fileorMethod, string $aktion): int
        {
            $client = new imonit_client();
            $tokenid = $client->gettokenid();
            $result = - 1;
            $url = $url = lastentry . '?tokenid=' . $tokenid . '&file=' . $fileorMethod . '&aktion=' . $aktion;
            // debug(detailiert, '<p>Debug:' . __METHOD__ . '( #' . __LINE__ . ' ' . imonit_client::version . ')<a href ="' . $url . '" target="new">Last entry request in neuem Fenster aufmachen</a> URL=' . $url . '</p>' . PHP_EOL);
            $erg = file($url);
            // var_dump ($erg);
            if (is_array($erg) == true) {
                $key = array_key_last($erg);
                $letzteZeile = $erg[$key];
                // debug (detailiert,'<p>Debug:'.__METHOD__.' (#'.__LINE__.' '.imonit_client::version.')Die letzte Zeile des Ergebnisses von den Mikroservice Aufruf lastentry ist "'. $letzteZeile.'" fileormethod='. $fileorMethod.' mit der Aktion:'. $aktion.' hat folgendes Ergebnis zurückgegeben:'. $result.'</p>'.PHP_EOL);

                $result = $letzteZeile;
                $result = (int) $result;
            } else {}
            if ($result == 0) {
                trace(detailiert, __METHOD__, __LINE__);
            }
            // debug (detailiert,'<p>Debug:'.__METHOD__.' (#'.__LINE__.' '.imonit_client::version.')Der Aufruf lastentry für fileormethod='. $fileorMethod.' mit der Aktion:'. $aktion.' hat folgendes Ergebnis zurückgegeben:'. $result.'</p>'.PHP_EOL);
            return $result;
        }

        /**
         * This is a constructor used to instanciate the class.
         * This constructor does not require any parameters to function.
         * The constructor retrieves the necessary information regarding the webapplication from the
         * token file which has to reside in the root directory of your web application and has to be named 'imonit.token'.
         */
        public function __construct()
        {
            $this->nextupdate = new DateTime();
            $this->token = itoken;
            $this->tokenfilename = $_SERVER['DOCUMENT_ROOT'] . '/' . itokenfilename;
            if (isset($_SERVER['HTTP_USER_AGENT'])) {
                $this->useragent = $_SERVER['HTTP_USER_AGENT'];
            } else {
                $this->useragent = 'unbekannt';
            }
            if (file_exists($this->tokenfilename)) {
                $filecontent = file($this->tokenfilename);
                $i = 0;
                $this->isvalid = false;
                while ($i < count($filecontent)) {
                    $zeile = explode('=', $filecontent[$i]);
                    // debug(detailiert,'<p>debug:'.__FILE__.' (#'.__LINE__.') Der Inhalt der token Datei: </p>'.PHP_EOL);
                    // var_dump ($zeile);

                    $i ++;
                    $zeile[0] = trim($zeile[0]);
                    switch ($zeile[0]) {
                        case 'tokenid':
                            $this->tokenid = (int) $zeile[1];
                            break;
                        case 'Version':
                            $this->tokenversion = trim($zeile[1]);
                            break;
                        case 'Kundennummer':
                            $this->customernumber = (int) $zeile[1];
                            break;
                        case 'itoken':
                            $this->token = trim($zeile[1]);
                            break;
                        case 'hash':
                            $this->hash = trim($zeile[1]);
                            // debug (detailiert,'<p>Debug:'.__FILE__.' (#'.__LINE__.') Der Hash Code aus dem Token wurde geladen. Wert:'. $hash.' </p>'.PHP_EOL);
                            break;
                        case 'website':
                            $this->websidename = trim($zeile[1]);
                            if ($_SERVER['SERVER_NAME'] != $this->websidename) {
                                debug(Fehler, '<p> Fehler:' . __FILE__ . ' (#' . __LINE__ . ') Die Webseite des Servers (' . $_SERVER['SERVER_NAME'] . ') Passt nicht zur Webseite des Tokens (' . $this->websidename . ')</p>' . PHP_EOL);
                            } else {}
                            break;
                        case 'nextTokenUpdate':
                            $this->nextupdate = new DateTime($zeile[1]);
                            break;
                        case 'version':
                            $this->tokenversion = trim($zeile[1]);
                            break;
                        case 'websiteid':
                            $this->websiteid = (int) trim($zeile[1]);
                            break;
                        default:
                            debug(Fehler, ' <p >Fehler:' . __FILE__ . ' (#' . __LINE__ . ') Das Feld:' . $zeile[0] . '  Mit dem Wert:' . $zeile[0] . ' Aus der Trockendatei "' . $this->tokenfilename . '"  wurde überhaupt nicht verwendet für die Instanzierung');
                            break;
                    }
                } // zeilenweise interpretieren der Tokendatei
            } else {
                debug(Fehler, '<p>Fehler:' . __FILE__ . ' (#' . __LINE__ . ') Es wurde kein Tocken gefunden.der Pfad zur tokendatei:' . $this->tokenfilename . '</p>' . PHP_EOL);
                trace(__METHOD__, __LINE__);
                return;
            }
            $this->isvalid = true;
        }

        /**
         * This destructor method is cleaning up the memory consumed by the instance of the imonit_clirent instance.
         * Even some of the library is programmed
         * to only use very little memory resources it is a good practice to unset the client instance at the end of your webpage or your class using the imonit micro services.
         */
        public function __destruct()
        {
            unset($this->token);
            unset($this->tokenfilename);
            unset($this->nextupdate);
            unset($this->tokenversion);
            unset($this->useragent);
            unset($this->websidename);
        }

        /**
         * This method returns the number of the Website fromthe token.
         * return int: Websiteid as stored in the token.
         */
        public function getwebsiteid(): int
        {
            return $this->websiteid;
        }

        /**
         * This method return the i-mon-it customer mumber the token belongs to as stored in the Token.
         *
         * @return int number of the customer;
         */
        public function getcustomernumber(): int
        {
            return $this->customernumber;
        }

        /**
         * This method simply returns the name of the token of that website loaded from the tokenfile as it has to be stored on the website.
         *
         * @return string Name of the token used by this client website.
         * @see imonit_client::token
         */
        public function gettokenname(): string
        {
            return $this->token;
        }

        /**
         * Returns the token API version, which is token is created by.
         *
         * @return string Version the token API
         * @see imonit_client::tokenversion
         */
        public function gettokenversion(): string
        {
            return $this->tokenversion;
        }

        /**
         * Returns an HTML table with information of the various attributes and their values of this token.
         *
         * @return string an HTML table containing information about the token used by this website
         */
        public function gettokeninfo(): string
        {
            $result = ' <table border="2"><thead><th>Attribute</th> <th >Value</th> </thead>' . PHP_EOL;

            $result .= '<tr><td>tokenid</td><td>' . $this->tokenid . '</td>' . PHP_EOL;
            $result .= '<tr><td>tokenname</td><td>' . $this->token . '</td>' . PHP_EOL;
            $result .= '<tr><td>tokeniversion</td><td>' . $this->tokenversion . '</td>' . PHP_EOL;
            $result .= '<tr><td>token Update required</td><td>' . $this->nextupdate->format(df) . '</td>' . PHP_EOL;
            $result .= '<tr><td>Customer number</td><td>' . $this->customernumber . '</td>' . PHP_EOL;
            $result .= '<tr><td>Name of the website</td><td>' . $this->websidename . '</td>' . PHP_EOL;
            $result .= '<tr><td>Name of the tokenfile</td><td>' . $this->tokenfilename . '</td>' . PHP_EOL;

            return $result;
        }

        /**
         * This method is returning the version number of the client library including the date of last change
         *
         * @return string string holding was number and the date of last change of this library ( format: nn.nn.nn dd.mm.yyyy)
         * @see imonit_client::version
         *
         */
        public static function version(): string
        {
            return imonit_client::version;
        }

        /**
         * With this method the token file will be updated by the newest version of the token file coming from the central i-mon-it services.
         *
         * @return bool Returns whether the updatewas a succes (true) or not (false)
         */
        public static function updatetoken(int $token, string $fileorMethod, int $line, int $app, bool $paid, string $aktion, string $version): bool
        {
            $result = false;
            $client = new imonit_client();
            $kundennummer = $client->getcustomernumber();
            // $token = $client->gettokenid ();
            // $app = $client->getwebsiteid();
            // $appname =App::getAppnamebyid ($app, $kundennummer);
            if ($app == - 1) {
                debug(Fehler, '<p ><b > Fehler: </b>' . __METHOD__ . ' (#' . __LINE__ . ' ' . imonit_client::version . ') Die Webanwendung #' . $app . ' gehört nicht zum Kunden #' . $kundennummer . ' </p>' . PHP_EOL);
                $text = 'Die Webanwendung #' . $app . ' gehört nicht zum Kunden #' . $kundennummer;
                imonit_Protokoll::Fehlermeldung($token, __METHOD__, __LINE__, $text, imonit_client::version, $kundennummer);
                trace(__METHOD__, __LINE__);
                return false;
            }
            $sessionid = session_id();
            $ua = getuseragent();
            $updateurl = updatetoken . '?token=' . $token . '&app=' . $app . '&sessionid=' . $sessionid . '&useragent=' . $ua . '&file=' . $fileorMethod;
            debug(detailiert, '<p>Debug:' . __METHOD__ . ' (#' . __LINE__ . ' ' . imonit_client::version . ') Link zum Download mit dem neuen Fenster geöffnet des Token für die Webanwendung #' . $app . '<a href ="' . $updateurl . '" targte="new"> Download Token</a> </p><p> URL des Microservice updatetoken:' . $updateurl . '</p>' . PHP_EOL);
            $newtoken = file_get_contents($updateurl);
            // var_dump ($_SERVER);
            $tokenfile = $_SERVER['CONTEXT_DOCUMENT_ROOT'] . 'imonit.token';
            debug(detailiert, '<p>Debug:' . __METHOD__ . ' (#' . __LINE__ . ' ' . imonit_client::version . ')Ziel Datei für das Token:<br>' . $tokenfile . '<br> Der Inhalt des erzeugten Tokens: </p>' . PHP_EOL);

            var_dump($newtoken);
            file_put_contents($tokenfile, $newtoken);
            debug(detailiert, '<p>Debug:' . __METHOD__ . '(#' . __LINE__ . ' ' . imonit_client::version . ')Es wurde das Token in die Datei "' . $tokenfile . '" geschrieben-</p>' . PHP_EOL);

            // @todo Es muss nur noch die Datei gespeichert werden

            return $result;
        }

        /**
         * This method checks back to the i-mon-it server, whether the token is developed
         *
         * @param string $toke
         *            Name of the token
         * @param string $hash
         *            take the hash value as it is provided in the token file to check whether or not the token is valid.
         *            
         * @return bool Returns a Boolean value whether the token is is valid or not.
         */
        public function verifytoken(string $token, string $hash): bool
        {
            $result = false;
            $token = trim($token);
            $hash = trim($hash);
            // trace(detailiert,__METHOD__,__LINE__);
            // $erg= file_get_contents($pingurl);
            $checkurl = checktoken . '?token=' . $token . '&hash=' . $hash;
            // debug(detailiert,' <p >Debug:'.__FILE__.' (#'.__LINE__.') URL zum Überprüfen des Tokens ('. $token.'):'. $checkurl.' </p>'.PHP_EOL);
            $erg = trim(file_get_contents($checkurl));
            // echo ' <p >'. __FILE__.' (#'.__LINE__.') Ergebnis ('. $checkurl.') ='. $erg.'ende </p>'.PHP_EOL;
            // var_dump ($erg);
            // debug (detailiert,'<p>Debug:'.__FILE__.'(#'.__LINE__.') Nach Überprüfung des Tokens:<br>X'. $erg.'X<br> Ende des Ergebnis. </p>'.PHP_EOL);
            if ($erg == tokenok) {
                $result = true;
                $this->isvalid = true;
            } else {
                $result = false;
                $this->isvalid = false;
            }
            // debug(detailiert,' <p >Debug:'.__FILE__.' (#'.__LINE__.'): Ergebnis der Überprüfung ob der Token in Ordnung ist:'.janein($result).' </p>'.PHP_EOL);
            return $result;
        }

        /**
         * This is one of the main methods provided by the library its test the i-mon-it server to record the start of a page.
         * This is a static function, which can be
         * used directly within your website.
         *
         * @param int $token
         *            Number of your token.
         * @param string $fileorMethod
         *            This is the reference to the calling page or class. When calling the method the typical PHP constants:
         *            __METHOD__ or __FILE__ is used to provide value for this call.
         * @param int $line
         *            This is a reference to the line number within the source code from where the recording for the page should be started.
         *            This is typically you done by using the PHP constant__LINE__
         * @param bool $paid
         *            this boolean value is indicating, whether you consider the calling webpage part of your payload. This value is impacting
         *            the reporting and the analysis of the i-mon-it offering.
         * @param string $aktion
         *            Often and PHP projects one single webpage is implementing my typical functions in order to properly track the different functions
         *            this parameter can be used.
         * @return int The call to the i-mon-it server will generate an unique ID, which should be stored and be provided as one of the parameters,
         *         when you call the metric and page method from the imonit_client library.
         * @see imonit_client::endpge()
         */
        public static function startPage(int $token, string $fileorMethod, int $line, bool $paid, string $aktion, string $version): int
        {
            if (session_status() != PHP_SESSION_ACTIVE) {
                // session_start();
                $sessionid = session_id();
            } else {
                $sessionid = 'keineSessionidgefunden';
            }
            $sessionid = session_id();
            if ($aktion == null || $aktion == '') {
                $aktion = 'no_action';
            } else {
                $aktion = trim($aktion);
            }
            // debug (detailiert,'<p>Debug:'.__METHOD__.' (#'.__LINE__.' '.imonit_client::version.') Der Useragentstring ist'. $_SERVER['HTTP_USER_AGENT'].' </p>'.PHP_EOL);

            $useragent = imonit_client::ua($_SERVER['HTTP_USER_AGENT']);
            // debug (detailiert,'<p>Debug:'.__METHOD__.' (#'.__LINE__.' '.imonit_client::version.') Die Useragentid ist'. $useragent.' </p>'.PHP_EOL);

            $version = Str_replace(' ', '_', $version);
            if ($sessionid == false) {
                // debug(Fehler,'<p><b>Fehler:</b>'.__METHOD__.' (#'.__LINE__.' '.imonit_client::version.') Es konnte keine SessionID ermittelt werden. Hier liegt ein Konfigurationsfehler oder sowas vor. </p>'.PHP_EOL);
                $sessionid = 'sessionid_fehlt';
            } else {}
            // debug (detailiert,' <p >Debug:'.__METHOD__.' (#'.__LINE__.' '.imonit_client::version.') Der Parameter Version hat den Wert"'. $version.'" </p>'.PHP_EOL);
            // debug (detailiert,' <p >Debug:'.__METHOD__.' (#'.__LINE__.' '.imonit_client::version.') Der Parameter fileormethod hat den Wert"'. $fileorMethod.'" </p>'.PHP_EOL);
            // debug (detailiert,' <p >Debug:'.__METHOD__.' (#'.__LINE__.' '.imonit_client::version.') Der Parameter line hat den Wert"'. $line.'" </p>'.PHP_EOL);

            $url = startpage . '?tokenid=' . $token . '&useragent=' . $useragent . '&sessionid=' . $sessionid . '&file=' . $fileorMethod . '&line=' . $line . '&paid=' . janein($paid) . '&aktion=' . $aktion . '&version=' . $version;
            $url = Str_replace(' ', '_', $url);
            // debug(detailiert,' <p > <ah ref="'. $url.'" target = "new"> Aufruf des gleich folgenden Startpage Mikroservice in einem neuen Fenster </a> die zugehörige URL lautet: <br >'. $url.' </p>'.PHP_EOL);
            $erg = file($url);
            // debug (detailiert,'<p>Debug:'.__METHOD__.' (#'.__LINE__.' '.imonit_client::version.')URL <br>'. $url.'<br></p>'.PHP_EOL);
//             debug(detailiert, '<p>Debug:' . __METHOD__ . ' (#' . __LINE__ . ' ' . imonit_client::version . ')URL zum Aufrufen des StartPage Service<a href ="' . $url . '" target="new">In neuem Fenster öffnen</a></p>' . PHP_EOL);
            if (is_array($erg) == true) {
                 //debug(detailiert,' <p >Debug:'.__METHOD__.' (#'.__LINE__.' '.imonit_client::version.')Das Ergebnis des Aufrufs i-mon-it Service "StartPage.php" <br >:'.print_array( $erg).' </p>'.PHP_EOL);
                $letzteZeile = (int) $erg[array_key_last($erg)];
            } else {
  //              debug(detailiert,' <p >Debug:'.__METHOD__.' (#'.__LINE__.' '.imonit_client::version.')Der Rückgabewert des "StartPage" Aufrufs ist vom Typ "'.gettype ($erg).'"<br> Die letzte Zeile wird jetzt durch den Aufruf "lastEntry " ermittelt. </p>'.PHP_EOL);
                $letzteZeile = imonit_client::lastentry($fileorMethod, $aktion);
            }
            // debug(detailiert, '<p>Debug:' . __METHOD__ . ' (#' . __LINE__ . ')Die letzte Zeile der Datei (<a href="'. $url .'"target="_new">'.$url.'</a>)<br>'. $letzteZeile . '</p>' . PHP_EOL);
            // echo '<p>'.__METHOD__.'(#.'.__LINE__.' '.imonit_client_lib_version().' Vor dem variablen Dump Zum Ergebnis des StartPage Aufrufs </p>'.PHP_EOL;
    //         var_dump ($erg);
            $result = $letzteZeile;
            // debug (detailiert,' <p >Debug:'.__METHOD__.' (#'.__LINE__.' '.imonit_client::version.') Das Ergebnis des startpage Aufrufs lautet:'. $result.' </p>'.PHP_EOL);
            return $result;
        }

        /**
         * This micro service is retrieving the identifier number for the browser also known as user agent.
         * The method asks for the string to pass the user agent identifier
         * to the method. This is an optional parameter as a method itself is using a standard function to retrieve the user agent directly.
         * The method returns the number of the user agent as it is returned from the i-mon-it micro service.
         *
         * @param string $ua
         *            This optional parameter should contain the three-ring which identifies the browser also known as useragent.
         * @return int Key of the useragent as it is known in the i-mon-it ecosystem.
         * @see getuseragent()
         */
        public static function ua(string $ua): int
        {
            $result = - 1;
            if ($ua == null || $ua == '') {
                $ua = getuseragent();
                // debug(detailiert,' <p >Debug:'.__FILE__.' (#'.__LINE__.' '.imonit_client::version.') Der Wert des useragent:"'. $ua.'" </p>'.PHP_EOL);
            } else {
                // debug(detailiert,' <p >Debug:'.__FILE__.' (#'.__LINE__.' '.imonit_client::version.') Der Wert des useragent:"'. $ua.'" </p>'.PHP_EOL);
            }
            $ua = strtr($ua, ' ', '_');
            $url = ua . '?useragent=' . $ua;
            // debug(detailiert,'<p>Debug:'.__METHOD__.' (#'.__LINE__.' '.imonit_client::version.') Die URL zum ermitteln derUseragent "'. $ua.'" UseragendID<a href= "'. $url.'" target="new"> Im neuen Fenster öffnen</a></p>'.PHP_EOL);
            // trace(__METHOD__, __LINE__);
            $erg = file($url);
            if (is_array($erg) == true) {
                $result = (int) $erg[array_key_last($erg)];
            } else {}
            // debug (detailiert,' <p>Debug:'.__METHOD__.' #'.__LINE__.' '.imonit_client::version.')Ergebnis der Ermittlung der ID des Browsers:'. $result.'</p>'.PHP_EOL);
            return $result;
        }

        /**
         * This static method is used to properly track a midpoint of your webpage and instruct the i-mon-it service to insert
         * and page record into the data mart.
         *
         * @param int $token
         *            This is the ID of the token, which is used to identify the website with the i-mon-it service.
         * @param int $startid
         *            This is the ID provided by the i-mon-it service start page at the time you called the start page method from this library.
         * @param string $fileorMethod
         *            Name of the file holding the webpage. The value is typically provided by the PHP constant __FILE__.
         * @param int $line
         *            this is a line inside the source code from where you calling the end page action. as value you typically provides a PHP constant __LINE__.
         * @param bool $paid
         *            Flag indicating whether you considering this page being part of the payload of your website.
         * @param string $aktion
         *            This is the action that webpage has performed.
         * @return int
         */
        public static function midPage(int $token, int $startid, string $fileorMethod, int $line, bool $paid, string $aktion, string $version): int
        {
            $sessionid = session_id();
            if ($sessionid == null || strlen($sessionid) == 0) {
                $sessionid = 'sessionid_fehlt';
                // debug(Fehler,'<p><b> Fehler: </b> </p>'.__METHOD__.' (#'.__LINE__.' '.imonit_client::version.') Es konnte keine Session ID ermittelt werden. </p>'.PHP_EOL);
            } else {}

            if ($aktion == null || $aktion == '') {
                $aktion = 'no_action';
            } else {
                $aktion = trim($aktion);
            }
            $useragent = getuseragent();
            // $version = strtr($version,' ','_');;
            $version = Str_replace(' ', '_', $version);
            // debug (detailiert,' <p >Debug:'.__METHOD__.' (#'.__LINE__.' '.imonit_client::version.') Der Parameter Version hat den Wert"'. $version.'" </p>'.PHP_EOL);
            // debug (detailiert,' <p >Debug:'.__METHOD__.' (#'.__LINE__.' '.imonit_client::version.') Der Parameter fileormethod hat den Wert"'. $fileorMethod.'" </p>'.PHP_EOL);
            // debug (detailiert,' <p >Debug:'.__METHOD__.' (#'.__LINE__.' '.imonit_client::version.') Der Parameter line hat den Wert"'. $line.'" </p>'.PHP_EOL);

            $url = trim(midpage) . '?tokenid=' . $token . '&useragent=' . $useragent . '&sessionid=' . $sessionid . '&file=' . $fileorMethod . '&startid=' . $startid . '&line=' . $line . '&paid=' . janein($paid) . '&aktion=' . $aktion . '&version=' . $version;
            $url = Str_replace(' ', '_', $url);
            // debug (detailiert,' <p >Debug:'.__METHOD__.' (#'.__LINE__.' '.imonit_client::version.')<a href="'.$url.'" target ="new"> Aufruf des midPage Aufruf zum neuen Fenster </a>."'. $url.'" </p>'.PHP_EOL);
            $erg = file($url);
            if (is_array($erg) == true) {

                $key = count($erg) - 1;
                // debug(detailiert, ' <p >Debug:' . __METHOD__ . ' (#' . __LINE__ . ' ' . imonit_client::version . ')Output des Aufrufs des Dienstes"midPage"' . (int) $erg[$key] . '</p>' . PHP_EOL);
                // print_array($erg);
                $letzteZeile = (int) $erg[$key];
                $result = $letzteZeile;
            } else {
                // debug(detailiert,' <p >Debug:'.__METHOD__.' (#'.__LINE__.' '.imonit_client::version.')Der Rückgabewert des "midPage" Aufrufs ist vom Typ "'.gettype ($erg).'"<br> Die letzte Zeile wird jetzt durch den Aufruf "lastEntry " ermittelt. </p>'.PHP_EOL);
                $letzteZeile = imonit_client::lastentry($fileorMethod, $aktion);
                $result = $letzteZeile;
                // $result =imonit_client::lastentry ( $token, $fileorMethod, $line, $paid, $aktion, $version);
            }
            // debug(detailiert, '<p>Debug:' . __METHOD__ . ' (#' . __LINE__ . ')die Ausgabe des Micro Service(<a href="'.$url.'" target="_new">'. $url . '</a>)<br>Ergebnis des Aufrufs:'.$result.'</p>' . PHP_EOL);
            // debug(detailiert, '<p>Debug:' . __METHOD__ . ' (#' . __LINE__ . ')Der letzte Datensatz der Datei (<a href="'.$url.'" target="_new">'. $url . '</a>)<br>Ergebnis des Aufrufs:'.$result.'</p>' . PHP_EOL);
            return (int) $result;
        }

        /**
         * This static method is used to properly track the endpoint of your webpage and instruct the i-mon-it service to insert
         * and page record into the data mart.
         *
         * @param int $token
         *            This is the ID of the token, which is used to identify the website with the i-mon-it service.
         * @param int $startid
         *            This is the ID provided by the i-mon-it service start page at the time you called the start page method from this library.
         * @param string $fileorMethod
         *            Name of the file holding the webpage. The value is typically provided by the PHP constant __FILE__.
         * @param int $line
         *            this is a line inside the source code from where you calling the end page action. as value you typically provides a PHP constant __LINE__.
         * @param bool $paid
         *            Flag indicating whether you considering this page being part of the payload of your website.
         * @param string $aktion
         *            This is the action that webpage has performed.
         * @return int
         */
        public static function endPage(int $token, int $startid, string $fileorMethod, int $line, bool $paid, string $aktion, string $version): int
        {
            $sessionid = session_id();
            if ($sessionid == null || strlen($sessionid) == 0) {
                $sessionid = 'sessionid_fehlt';
                // debug(Fehler,'<p><b> Fehler: </b> </p>'.__METHOD__.' (#'.__LINE__.' '.imonit_client::version.') Es konnte keine Session ID ermittelt werden. </p>'.PHP_EOL);
            } else {}

            if ($aktion == null || $aktion == '') {
                $aktion = 'no_action';
            } else {
                $aktion = trim($aktion);
            }
            $useragent = getuseragent();
            // $version = strtr($version,' ','_');;
            $version = Str_replace(' ', '_', $version);
            // debug (detailiert,' <p >Debug:'.__METHOD__.' (#'.__LINE__.' '.imonit_client::version.') Der Parameter Version hat den Wert"'. $version.'" </p>'.PHP_EOL);
            // debug (detailiert,' <p >Debug:'.__METHOD__.' (#'.__LINE__.' '.imonit_client::version.') Der Parameter fileormethod hat den Wert"'. $fileorMethod.'" </p>'.PHP_EOL);
            // debug (detailiert,' <p >Debug:'.__METHOD__.' (#'.__LINE__.' '.imonit_client::version.') Der Parameter line hat den Wert"'. $line.'" </p>'.PHP_EOL);
            $url = trim(endpage) . '?tokenid=' . $token . '&useragent=' . $useragent . '&sessionid=' . $sessionid . '&file=' . $fileorMethod . '&startid=' . $startid . '&line=' . $line . '&paid=' . janein($paid) . '&aktion=' . $aktion . '&version=' . $version;
            $url = Str_replace(' ', '_', $url);
            // debug (detailiert,'<p>Debug:'.__METHOD__.' (#'.__LINE__.' '.imonit_client::version.')<a href="'.$url.'" target ="new"> Aufruf des endPage Aufruf zum neuen Fenster </a>."'. $url.'" </p>'.PHP_EOL);
            // debug (detailiert,'<p>Debug:'.__METHOD__.' (#'.__LINE__.' '.imonit_client::version.') Vor der Ausgabe des Ergebnisses des Aufrufs von endPage: </p>'.PHP_EOL);

            $erg = file($url);
            // var_dump($erg);
            if (is_array($erg) == true) {

                $key = count($erg) - 1;
                // debug (detailiert,' <p >Debug:'.__METHOD__.' (#'.__LINE__.' '.imonit_client::version.')Output des Aufrufs des Dienstes"endPage"'. (int)$erg [$key].'</p>'.PHP_EOL);
                // print_array($erg);
                $letzteZeile = (int) $erg[$key];
                $result = $letzteZeile;
            } else {
                // debug(detailiert,' <p >Debug:'.__METHOD__.' (#'.__LINE__.' '.imonit_client::version.')Der Rückgabewert des "EndPage" Aufrufs ist vom Typ "'.gettype ($erg).'"<br> Die letzte Zeile wird jetzt durch den Aufruf "lastEntry " ermittelt. </p>'.PHP_EOL);
                $letzteZeile = imonit_client::lastentry($fileorMethod, $aktion);
                $result = $letzteZeile;
                // $result =imonit_client::lastentry ( $token, $fileorMethod, $line, $paid, $aktion, $version);
            }
            // debug(detailiert, '<p>Debug:' . __METHOD__ . ' (#' . __LINE__ . ')die Ausgabe des Micro Service(<a href="'.$url.'" target="_new">'. $url . '</a>)<br>Ergebnis des Aufrufs:'.$result.'</p>' . PHP_EOL);
            // debug(detailiert, '<p>Debug:' . __METHOD__ . ' (#' . __LINE__ . ')Der letzte Datensatz der Datei (<a href="'.$url.'" target="_new">'. $url . '</a>)<br>Ergebnis des Aufrufs:'.$result.'</p>' . PHP_EOL);
            return (int) $result;
        }

        /**
         * This static method is used the record the start of the execution of the method in your application.
         *
         * @param int $token
         *            This is the number of the token of your website.
         * @param string $fileorMethod
         *            This is the source file which you want a morning tour using the star service. Typically as the stock service is Used
         *            inside the core application you can use the PHP constant__METHOD__, which way you capture the complete identifier of your class.
         * @param int $line
         *            This is the line of your source code, which is used to call the i-mon-it service. Typically you can use therefore the PHP constant __LINE__.
         * @param string $aktion
         *            This is an option to specify even more the curent Action item an to diffferentuate the use of the function.
         * @return int The method returns the unique ID by which the tracking request is captured within thei-mon-it service.
         * @see imonit_client::end ()
         */
        public static function start(int $token, string $fileorMethod, int $line, bool $paid, string $aktion, string $version): int
        {
            if ($version == '' || $version == null) {
                debug(Fehler, ' <p > <b>Fehler:</b>' . __METHOD__ . ' (#' . __LINE__ . ' ' . imonit_client::version . ')Der Parameter Version ("' . $version . ') hat keinen gültigen Wert. </p>' . PHP_EOL);
                trace(Fehler, __METHOD__, __LINE__);
                $version = 'unbekannteVersion';
            } else {
                $version = trim($version);
            }
            if ($aktion == null || $aktion == '') {
                $aktion = 'no action';
            } else {
                $aktion = trim($aktion);
            }
            $sessionid = session_id();
            $result = - 1;
            // $version = strtr($version,' ','_');
            $useragent = getuseragent();
            $ua = imonit_client::ua($useragent);
            if ($ua == - 1) {
                $ua = imonit_client::ua($useragent);
            } else {}
            if (ua == - 1) {
                $ua = $useragent;
            }

            $version = Str_replace(' ', '_', $version);
            // debug (detailiert,' <p >Debug:'.__METHOD__.' (#'.__LINE__.' '.imonit_client::version.') Der Parameter Version hat den Wert"'. $version.'" </p>'.PHP_EOL);
            // debug (detailiert,' <p >Debug:'.__METHOD__.' (#'.__LINE__.' '.imonit_client::version.') Der Parameter fileormethod hat den Wert"'. $fileorMethod.'" </p>'.PHP_EOL);
            // debug (detailiert,' <p >Debug:'.__METHOD__.' (#'.__LINE__.' '.imonit_client::version.') Der Parameter line hat den Wert"'. $line.'" </p>'.PHP_EOL);

            $url = start . '?tokenid=' . $token . '&useragent=' . $ua . '&sessionid=' . $sessionid . '&file=' . $fileorMethod . '&line=' . $line . '&paid=' . janein($paid) . '&aktion=' . $aktion . '&version=' . $version;
            if (indev) {
                // debug(detailiert, '<p>Debug:' . __METHOD__ . ' (#' . __LINE__ . ' '.imonit_client::version.')Vor Aufruf des Startdienstes(Mit Parameter Methode='. $fileorMethod.') <br >'. $url.' <br ><a href="'. $url . '" target="new">Start Dienst in neuem Fenster</a></p>' . PHP_EOL);
            } else {
                // es wird gar nichts gemacht.
                // debug (detailiert,'<p>Debug:'.__METHOD__.' (#'.__LINE__.') Wert der Konstante indev'.janein (indev).' </p>'.PHP_EOL);
            }

            $erg = file($url);
            // debug(detailiert,'<p>Debug:'.__METHOD__.' (#'.__LINE__.' '.imonit_client::version.') Die Rückgabewerte des Serveraufrufs: Typ der Rückgabevariablen:'.gettype($erg). '</p>'.PHP_EOL);
            // var_dump ($erg);
            if (gettype($erg) != "array") {
                $id = imonit_client::lastentry($fileorMethod, $aktion);
                $erg = Array(
                    'letzteZeile' => (string) $id
                );
            } else {}
            $letzteZeile = $erg[array_key_last($erg)];
            $result = (int) $letzteZeile;
            // debug(detailiert, '<p>Debug:' . __METHOD__ . ' (#' . __LINE__ . ')Ergebnis des Aufrufs für die Methode(' . $fileorMethod . ')<br>'.$result.'</p>' . PHP_EOL);
            return $result;
        }

        /**
         * This method should be used in case your function is performing heavy-duty operations and he want to have more than just a start and end point of your method
         * being captured and tracked by the i-mon-it service.
         *
         * @param int $token
         *            This is a number of the token of your website.
         * @param int $startid
         *            This is the ID you did get when you call it the start i-mon-it service. Bypassing this on to the mixed tracking request and later to the end i-mon-it service. You can ensure
         *            that the i-mon-it service will correctly track your function flow over the overall course of the method execution
         * @param string $methodorfile
         *            Here you should use the PHP constant__METHOD__ in order to capture the proper quotation of your class and the method for which you call this function.
         * @param int $line
         *            This is the line of code of the method call. Typically that PHP constant __LINE__ is used to document this.
         * @param bool $paid
         *            Indicator whether you consider this method and part of your payload of your application.
         * @param string $aktion
         *            This is a possibility to further differenciate the context in which this is called.
         * @return int The method returns a unique ID from the i-mon-it tracking service.
         * @see imonit_client::start()
         * @see imonit_client::end()
         */
        public static function mid(int $token, int $startid, string $methodorfile, int $line, bool $paid, string $aktion, string $version): int
        {
            if ($aktion == null || $aktion == '') {
                $aktion = 'no action';
            } else {
                $aktion = trim($aktion);
            }

            $result = - 1;
            $useragent = getuseragent();
            $methodorfile = trim($methodorfile);
            $ua = uanr($useragent);
            $sessionid = session_id();
            $version = strtr($version, ' ', '_');
            $url = mid . '?startid=' . $startid . '&sessionid=' . $sessionid . '&useragent=' . $ua . '&token=' . $token . '&file=' . $methodorfile . '&line =' . $line . '&paid =' . janein($paid) . '&aktion = ' . $aktion . '&version=' . $version;
            $url = mid . '?startid=' . $startid . '&sessionid=' . $sessionid . '&useragent=' . $ua . '&tokenid=' . $token . '&file=' . $methodorfile . '&line=' . $line . '&paid=' . $paid . '&aktion=' . trim($aktion) . '&version=' . $version;

            // debug (detailiert,' <p >Debug:'.__METHOD__.' (#'.__LINE__.' '.version.')die URL zum Aufruf des "mid"Dienstes: <br >'. $url.' <a href ="'. $url.'" target = "new"> Mid Dienst im neuen Fenster darstellen</a> </p>'.PHP_EOL);

            $erg = file($url);
            // var_dump($erg);
            if (is_array($erg)) {
                $letzteZeile = $erg[array_key_last($erg)];
            } else {
                $text = 'Der Aufruf des Mikroservice "mid" hat einen Fehler zurückgeliefert.Als Ergebnis dieses Fehlers wird die Methode nun den Wert 0. Als  id für den Aufruf des Mikroservices "mid" zurückgeben.';
                debug(Fehler, ' <p > <b >Fehler </b>' . __METHOD__ . ' (#' . __LINE__ . ' ' . imonit_client::version . ') Der Aufruf des Mikroservice "mid"hat einen Fehler zurückgeliefert.  als Ergebnis liefert die Methode jetzt als midID 0  zurück.</p>' . PHP_EOL);
                $client = new imonit_client();
                $kundnr = $client->getcustomerid();
                imonit_fehlermeldung($token, __METHOD__, __LINE__, $text, imonit_client::version, $kundennr);
                $letzteZeile = 0;
            }

            $result = $letzteZeile;
            return $result;
        }

        /**
         * This static function as a recording the endpoint of the method you are tracking by the i-mon-it service.
         *
         * @param int $token
         *            This is the number of your token of your website
         * @param int $startid
         *            this is the i-mon-it service ID, which you got when you called the start service.
         * @param String $fileorMethod
         *            This is the name of the class and method you're calling the i-mon-it service from. In the case of the end Service
         *            this is typically__MEWTHOD__.
         * @param int $line
         *            This is line of code within your source code you according the end service from. The value used here is typically the PHP constant __LINE__.
         * @param bool $paid
         *            This flag is indicating whether or not you consider this method in this tracking point part of the payload of your website.
         * @return int Returns of the unique i-mon-it service ID provided by the central i-mon-it service.
         * @see imonit_client::Start()
         * @see imonit_client::mid()
         */
        public static function end(int $token, int $startid, String $fileorMethod, int $line, bool $paid, string $aktion, string $version): int
        {
            if ($aktion == null || $aktion == '') {
                $aktion = 'no action';
            } else {
                $aktion = trim($aktion);
            }

            $result = - 1;

            $fileorMethod = trim($fileorMethod);
            $paid = trim(janein($paid));
            $sessionid = session_id();
            $useragent = getuseragent();
            $ua = uanr($useragent);
            $version = Str_replace(' ', '_', $version);
            $url = end . '?startid=' . $startid . '&sessionid=' . $sessionid . '&useragent=' . $ua . '&tokenid=' . $token . '&file=' . $fileorMethod . '&line=' . $line . '&paid=' . $paid . '&aktion=' . trim($aktion) . '&version=' . $version;
            if (indev) {
                // debug (detailiert,'<p>Debug:'.__METHOD__.' (#'.__LINE__.') Vor Aufruf des end Dienstes. URL:<br>'.$url.'<br><a href="'. $url.'" target="new">Enddienst in neuem Fenster</a></p>'.PHP_EOL);
            } else {
                // debug (detailiert,'<p>Debug:'.__METHOD__.' (#'.__LINE__.') Wert der Konstante indev'.janein (indev).' </p>'.PHP_EOL);
            }
            $erg = file($url);
            // debug (detailiert,'<p>Debug:'.__METHOD__.' (#'.__LINE__.' '.imonit_client_lib_version().') Vor der Anzeige des Ergebnis des Aufrufs end Mikrodienstes. </p>'.PHP_EOL);
            // var_dump ($erg);
            if (is_array($erg) == true) {
                $letzteZeile = $erg[array_key_last($erg)];
                $result = (int) $letzteZeile;
            } else {
                $result = 0;
            }
            // debug (detailiert,'<p>Debug:'.__METHOD__.' (#'.__LINE__.' '.imonit_client_lib_version().') Ergebnis des end Aufrufs von:'.$fileorMethod.' '. $result.'</p>'.PHP_EOL);

            return $result;
        }

        /**
         * This method is returning the token ID of your website provided by i-mon-it
         *
         * @return int ID of the token provided by i-mon-it
         */
        public function gettokenid(): int
        {
            return $this->tokenid;
        }

        /**
         * This method is returning a bullion flak whether or not the client instance and the corresponding token are valid.
         *
         * @return bool Returns true in case the client instance is valid, false will be returned otherwise.
         */
        public function isvalid(): bool
        {
            return $this->isvalid;
        }
    }
}